<?php

function rateLimit($db, $config, $success) {
    $ip = $_SERVER['REMOTE_ADDR'];
    $dev = getDeviceSignature();

    if ($success) {
        // نجاح → إعادة ضبط العدّاد
        $stmt = $db->prepare("DELETE FROM attempts WHERE device=?");
        $stmt->execute([$dev]);
        return;
    }

    // احضر عدد المحاولات
    $stmt = $db->prepare("SELECT * FROM attempts WHERE device=?");
    $stmt->execute([$dev]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        $stmt = $db->prepare("INSERT INTO attempts(device,count,last_try) VALUES(?,?,NOW())");
        $stmt->execute([$dev,1]);
    } else {
        $count = $row['count'] + 1;
        if ($count >= $config['max_attempts']) {
            // بلوك
            $stmt = $db->prepare("INSERT INTO blocked(device,ip,created_at) VALUES(?,?,NOW())");
            $stmt->execute([$dev,$ip]);

            $stmt = $db->prepare("DELETE FROM attempts WHERE device=?");
            $stmt->execute([$dev]);

            http_response_code(403);
            echo json_encode(["error"=>"BLOCKED"]);
            exit;
        }
        $stmt = $db->prepare("UPDATE attempts SET count=?, last_try=NOW() WHERE device=?");
        $stmt->execute([$count, $dev]);
    }
}
